---
title: 연동 유의사항
description: 토스페이먼츠 (신 모듈) 연동 유의사항을 소개합니다.
targetVersions:
  - v1
---

## 토스페이먼츠와 사전 계약이 필요한 경우

아래 기능을 사용하시려면 토스페이먼츠에 사전 신청 후 계약이 완료되어야 합니다.

계약 하지 않은 경우 해당 기능 이용시 결제 승인에 실패하거나, 승인에 성공하더라도 의도한 바와는 다른
응답(결제창에서 에스크로 결제를 했으나 비-에스크로 결제 응답을 받음)을 얻게 될 수 있습니다.

- 간편결제 사용
- 면세 / 복합과세 사용
- 할부 사용
- 상점 부담 무이자 할부 사용
- 상품권 결제 사용
- 카드사 포인트 사용
- 에스크로 사용

## 카드 결제

<details>

<summary>appCard 파라미터는 일부 카드사에 대해서만 적용 됨</summary>

토스페이먼츠의 경우 카드 결제시, 앱 카드로만 결제할 수 있도록 제한하는 appCard 파라미터를 지원하지만 지원 범위가 아래와 같이 제한적입니다.

- 지원 가능 카드: 국민, 농협, 롯데, 삼성, 신한, 현대, 우리, 하나
- 지원 불가 카드: 씨티

</details>

<details>

<summary>display.card\_quota 파라미터는 다른 PG사와 다르게 동작 함</summary>

display.card\_quota 파라미터로 결제창에 렌더링 될 할부 개월수 리스트를 제어할 수 있습니다. 다른 PG사는 전달한 값만 렌더링 되지만, 토스페이먼츠의 경우에는 토스페이먼츠 자체 정책에 따라 **일시불 \~ 전달한 값 중 최대값까지 모두 렌더링**됩니다.

- 예1. 일시불만 허용

  ```json
  {
    "display": {
      "card_quota": [0]
    }
  }
  ```

- 예2. 5개월만 허용

  ```json
  {
    "display": {
      "card_quota": [5]
    }
  }
  ```

- 예3. \[토스페이먼츠] 일시불 \~ 5개월까지 허용

  ```json
  {
    "display": {
      "card_quota": [3, 5] // 3과 5 중에 최대값이 5이기 때문에 일시불 ~ 5개월까지 모두 렌더링 된다
    }
  }
  ```

- 예3. \[타 PG사] 일시불 \~ 5개월까지 허용

  ```json
  {
    "display": {
      "card_quota": [0, 1, 2, 3, 4, 5]
    }
  }
  ```

- 예4. \[토스페이먼츠] 3개월과 5개월만 허용 → **불가능**

- 예5. \[타 PG사] 3개월과 5개월만 허용

</details>

<details>

<summary>무이자 할부가 적용 되어도 ISP 계열 카드로 결제시에는 “무이자” 표기가 되지 않음</summary>

고객사는 토스페이먼츠와 사전 계약 또는 카드사 정책에 따라 무이자 할부 기능을 사용할 수 있습니다. 이에 따라 결제창 내에서 각 카드 사별 최대 무이자 할부 개월수에 따라 할부 개월수 옆에 “무이자” 또는 “무”라고 표기 됩니다.

- 예1. 삼성카드 - 최대 3개월 무이자 할부 적용 → 3개월까지 “무” 표기

  (관련 이미지 첨부)

하지만 ISP 계열 카드의 경우에는 실제로 무이자가 적용된다고 하더라도 “무이자” 여부가 표기되지 않습니다.

- 예2. BC카드 - 최대 12개월 무이자 할부 적용 → 표기 없음 → 실제 결제 승인시 무이자 할부 적용은 됨

  (관련 이미지 첨부)

이는 ISP 계열 카드사 결제시 사용되는 페이북 앱 특성에 따른 것으로 실제 결제 승인시에는 정상적으로 무이자 할부가 적용됩니다.

</details>

<details>

<summary>할부 기간 선택 관련 이슈</summary>

모바일 웹 - 카드 결제시 토스페이먼츠 결제창 내에서 간편결제의 경우 할부 기간 선택이 불가능하고, 간편결제 외의 모든 카드사의 경우엔 할부 기간 선택이 가능합니다.

- 모바일 웹 - 간편결제 외 카드사: 할부 기간 선택 가능\
  ![](</gitbook-assets/ko/image (178).png>)

- 모바일 웹 - 간편결제: 할부 기간 선택 불가능\
  ![](</gitbook-assets/ko/image (351).png>)

반면, PC - 카드 결제 - ISP계열의 경우에는 토스페이먼츠 결제창 내에서도 할부 기간 선택이 불가능 하며, 대신 ISP 페이북 팝업에서는 선택이 가능합니다.

- PC - 카드결제 - ISP 선택: 할부 기간 선택 불가능

  [이미지 링크](<https://developers.portone.io/gitbook-assets/ko/image (184).png>)

- PC - 카드결제 - ISP 선택 - 페이북 팝업: 할부 기간 선택 가능

다소 헷갈릴 수 있으나 간편결제는 간편결제 앱에서 할부 개월수를 선택할 수 있어 토스페이먼츠 결제창에서 선택할 수 없다는 토스 답변이 있었습니다.

</details>

<details>

<summary>카카오페이 13개월 이상 할부 개월수 불가능한 이슈</summary>

카카오페이 자체에서 13개월 이상 할부 결제를 지원하지 않기 때문에, 카카오페이로는 최대 12개월까지 할부 결제가 가능합니다.

</details>

<details>

<summary>카카오페이 일부 카드의 경우 카드 정보를 확인할 수 없는 이슈</summary>

카카오페이로 결제시 일부 카드(2022년 6월 이후 카드사 측에서 신규 생성 된 카드)의 경우, 카카오페이 → 토스페이먼츠로 카드 정보를 정상적으로 내려주지 않기 때문에 포트원 REST API로 결제내역 조회(GET /payments/{imp\_uid})시 카드사 정보(card\_code: 카드 코드, card\_name: 카드 이름)를 확인할 수 없습니다.

</details>

## 카드사 다이렉트 호출

<details>

<summary>고정 할부 개월수(card.direct.quota)를 보내지 않으면 무조건 일시불로 결제 됨</summary>

토스페이먼츠는 카드사 다이렉트 호출시 **quota 값을 전달하지 않는 경우에는 무조건 일시불로 결제**가 됩니다.

따라서 카드사 다이렉트 호출시에는 반드시 구매자가 할부 개월수를 선택할 수 있는 UI/UX를 만들어주신 후 결제창 호출(IMP.request\_pay)시 card.direct.quota값을 넘겨야 합니다.

- 예1. 현대카드 다이렉트 호출 → 무조건 일시불로 결제 됨

  ```json
  {
    "card": {
      "direct": {
        "code": "367"
      }
    }
  }
  ```

- 예2. 삼성카드 다이렉트 호출 + 5개월 고정 할부 개월수 지정 → 5개월 할부 적용

  ```json
  {
    "card": {
      "direct": {
        "code": "365",
        "quota": 5
      }
    }
  }
  ```

</details>

<details>

<summary>고정 할부 개월수(card.direct.quota)를 보내도 카드 결제창에서 결제 될 할부 개월수를 확인할 수 없음</summary>

카드사 다이렉트 호출시 quota 값을 보내도 **실제로 카드사 결제창에서는 결제시 적용 될 할부 개월수를 확인할 수 없습니다.** (물론 실제 승인시에는 전달한 quota값 만큼 할부 적용이 됨)

단, ISP 계열의 카드사인 경우에는 페이북 팝업에서 확인이 가능하며 이 값을 사용자가 변경 할 수는 없습니다.

- 예. BC카드 다이렉트 호출 + 5개월 고정 할부 개월수 지정\\

  [이미지 링크](<https://developers.portone.io/gitbook-assets/ko/image (181).png>)



```json
{
  "card": {
    "direct": {
      "code": "361",
      "quota": 5
    }
  }
}
```

</details>

<details>

<summary>페이북을 통한 ISP 계열 카드 결제시, 카드 번호가 정상적으로 내려오지 않음</summary>

페이북 통한 ISP 계열 카드 결제시 토스페이먼츠로부터 실제 카드 번호와 다른 9200으로 시작하는 카드 번호가 내려오고 있어 결제 승인 내역 조회(POST `/payments/{imp_uid}`)시 응답되는 카드 번호(`card_numer`)가 정확하지 않습니다.

</details>

<details>

<summary>사파리 브라우저에서 ISP 계열 카드 결제 불가능</summary>

사파리 브라우저에서 ISP 계열 카드 결제를 위한 페이북 팝업 호출에 이슈가 있습니다. 이는 토스페이먼츠 결제창에서 페이북으로 넘어가는 과정에서 발생하는 이슈로 포트원과는 무관합니다.

</details>

## 가상계좌

<details>

<summary>가상계좌 발급 가능 은행</summary>

토스페이먼츠를 통한 가상계좌는 경남은행, 광주은행, KB국민은행, IBK기업은행, NH농협은행, DGB대구은행, 부산은행, 새마을금고, Sh수협은행, 신한은행, 우리은행, 우체국예금보험, 하나은행에서 발급받을 수 있습니다.

</details>

<details>

<summary>가상계좌 발급 완료시 예금주 명 알 수 없음</summary>

토스페이먼츠는 가상계좌 발급 완료시 발급 된 가상계좌의 **예금주 명을 전달해주지 않습니다**. 따라서 포트원 REST API로 결제내역 조회(GET `/payments/{imp_uid}`)시 `vbank_holder`가 null로 전달됩니다.

실제 가상계좌 예금주 명은 토스페이먼츠와 계약된 고객사 이름과 동일하다고 하니, 참고 부탁드립니다.

</details>

## 간편결제

<details>

<summary>대부분의 간편결제에 대해 결제 테스트 불가능</summary>

토스페이먼츠는 SSGPAY, 네이버페이, 카카오페이, 페이코 등 대부분의 간편결제에 대해 결제 테스트 기능을 제공하고 있지 않습니다. 따라서 테스트용 설정으로 간편결제를 시도하면 `[PAY_PROCESS_ABORTED] Toss Payments와 계약된 결제수단(SSG)이 아닙니다.` 와 같은 에러 메시지가 리턴되면서 결제창이 호출되지 않습니다. 이 경우 토스페이먼츠와 실 상점 계약을 하여 실 상점 정보를 포트원 관리자페이지에 다시 등록한 후 시도하셔야 합니다.

</details>

<details>

<summary>카드 외 복합 결제 건에 대해서는 정확한 결제 수단 정보 확인 불가능</summary>

간편결제로는 여러가지 결제수단으로 결제 할 수도 있고 각 결제 수단을 혼합하여 복합 결제를 할 수도 있습니다. 이때 토스페이먼츠는 구매자가 정확히 어떤 방식으로 결제했는지 데이터를 내려주지 않으며 그 내용은 아래와 같습니다.

1. 카드로 결제한 경우에는 카드 정보(카드사, 카드 유형 등)를 확인할 수 있습니다.
2. 하지만 카드 외의 결제 수단으로 결제를 한 경우에는, 결제 수단 세부 정보(어떤 은행, 포인트, 머니인지)를 확인할 수 없습니다.
3. 카드가 포함 된 결제 건인지 아닌지는 구분이 됩니다. 따라서 카드가 포함 된 결제 건이면 결제 수단을 `card` 로 기록합니다.
4. 하지만 계좌 / 포인트 / 머니 중 어떤 것으로 결제 됐는지 구분되지 않습니다. 따라서 카드가 포함 되지 않은 결제 건이면 결제 수단을 `point`로 기록합니다. 실제로 등록된 계좌로 결제 됐다고 하더라도 포인트나 머니로 결제 된 것과 구분되지 않기 때문에 결제 수단을 `trans`로 저장하지 않습니다.

</details>

<details>

<summary>고정 할부 개월수 적용해도 일시불과 함께 표기</summary>

네이버페이, L페이, 토스페이, 삼성페이 등 일부 간편결제사의 경우 해당 간편결제사의 정책에 따라 **고정 할부 개월수를 설정하더라도 일시불과 함께 렌더링**됩니다.

- 예. 네이버페이 - 5개월 고정 할부 설정시, 일시불과 5개월 할부 모두 선택 가능

  ```json
  {
    "pay_method": "naverpay",
    "display": {
      "card_quota": [5]
    }
  }
  ```

  (관련 이미지 첨부)

</details>

## 기타

- 상품권 결제는 부분취소가 불가능
- 테스트 결제 건은 매출 전표 확인이 불가능
- 간편결제 - 카드 외의 결제 건은 매출 전표 확인이 불가능
- 간편결제 - L페이 결제창 배경 화면 투명도 이슈로 겹쳐보이는 현상
- `cashReceiptType` 파라미터로 인한 오동작 관련 이슈

<details>

<summary>지출증빙 발급번호 이슈</summary>

`bypass.cashReceiptType`(현금성 결제시, 결제창 내에 현금영수증 발급 유형 설정 값)을 corporate(지출 증빙)으로 설정하고 결제창을 호출하면 토스페이먼츠 결제창에서 현금영수증 발급 유형이 “지출증빙”으로 표기되어있으나 발급 번호가 사업자등록번호가 아닌 주민등록번호로 설정되어있으며 이를 변경할 수 없는 토스 버그가 있습니다. 따라서 구매자는 현금영수증 발급 유형을 지출증빙용이 아닌 소득공제용이나 미발행으로 바꿔서 선택한 후 다시 지출증빙용을 선택해야합니다.

[이미지 링크](<https://developers.portone.io/gitbook-assets/ko/image (180).png>)

</details>

<details>

<summary>간편결제 - SSG페이 결제시 토스페이먼츠 결제창에서 휴대폰 번호를 입력하지 않아도 다음으로 넘어가는 이슈</summary>

간편결제 - SSG페이 결제시 토스페이먼츠 결제창에서 휴대폰 번호를 입력해야 구매자의 휴대폰에 깔린 SSG 페이 앱에서 푸쉬 알림이 오면서 결제를 할 수 있는데, 현재 토스페이먼츠 결제창에서 휴대폰 번호를 입력하지 않아도 다음 단계로 이동되기 때문에 구매자는 이 경우 무한 대기를 하게 됩니다. 휴대폰 번호를 입력을 하지 않은 경우엔 다음 단계로 이동할 수 없도록 토스 측의 조치가 필요합니다.![](</gitbook-assets/ko/image (188).png>)

</details>

<details>

<summary>삼성페이 결제 중단시 결제창 잘림 현상</summary>

삼성페이 결제창 렌더링 후 장시간 대기했다가 우측 상단 X 버튼을 눌러 결제 프로세스를 중단하면 아래와 같이 잘린 화면이 렌더링됩니다. 가로 스크롤도 동작하지 않아(스크롤은 움직이지만 화면은 고정) 사용자 경험이 다소 저해됩니다.

[이미지 링크](<https://developers.portone.io/gitbook-assets/ko/image (177).png>)

</details>

<details>

<summary>현금영수증 발급 API 호출시 유효성 검사를 하지 않음</summary>

예를 들어 현금영수증 발급 유형(type)을 소득공제(person)으로 보내고 현금영수증 발급 번호(identifier)를 사업자 등록번호로 보내면 실제로는 현금영수증 발급에 실패해야하지만 토스페이먼츠에서 유효성 검사를 하지 않아 그대로 성공 응답을 보내고 있습니다.

따라서 원활한 현금영수증 발급을 위해서는 현금영수증 발급 API 호출시 현금영수증 정보를 정확하게 입력하셔야 합니다.

</details>

<details>

<summary>사파리 / 파이어폭스 브라우저 내 팝업 블로커 이슈</summary>

사파리 / 파이어폭스 브라우저에서 설정에서 팝업이 차단되어있는 경우 페이북 결제시 팝업이 뜨지 않아 결제 진행이 되지 않거나 가상계좌 발급이나 휴대폰 소액결제시 승인에 실패하는 등 결제가 원활하게 진행되지 않을 수 있으니, 반드시 팝업을 해제하시고 시도해주시기 바랍니다.

</details>

<details>

<summary>IE 브라우저 - 카드결제 - 페이코 선택시 아래와 같이 결제창이 잘리는 이슈</summary>

이에 대해 토스로부터 “IE 에서 fade out 이 되고 있으므로 수정에 우선순위를 두기 어려울것 같습니다.”라는 답변을 받았습니다.

</details>

<details>

<summary>IE 브라우저 결제 중단시 에러 메시지 인코딩 이슈</summary>

IE 브라우저에서 결제 중단(결제 승인/실패 이전에 결제창을 명시적으로 닫을때)시 토스페이먼츠로부터 아래와 같이 인코딩 된 에러 메시지가 전달되는 이슈가 있습니다. (이를 디코딩해보면 “사용자가결제를취소하였습니다”라는 메시지)

`%EC%82%AC%EC%9A%A9%EC%9E%90%EA%B0%80 %EA%B2%B0%EC%A0%9C%EB%A5%BC %EC%B7%A8%EC%86%8C%ED%95%98%EC%98%80%EC%8A%B5%EB%8B%88%EB%8B%A4`

이에 대해 토스로부터 “IE 의 인코딩 이슈라서 저희가 수정해 드리기가 애매하고, 내부적으로 IE 는 fadeout 되어 더 이상 공식적으로 지원을 하지 않고 있습니다.”라는 답변을 받았습니다.

</details>
